---
title: Lecture 40：多元复合函数的求导法则
tags:
  - 数学
  - 微分方程
categories: 
date: 2024-02-03
---
**本章内容**
+ （1）多元函数的基本概念
+ （2）多元函数微分法
+ （3）多元函数的极值与最值

**本节内容概要**
+ （一）多元函数的极限
+ （二）多元函数连续性
+ （三）偏导数 
+ （四）全微分
+ （五）连续、可微、可导关系

**本节常考题型**
+ 讨论连续性、可导性、可微性

---
## 41.1 多元函数的极限
### 41.1.1 多元函数极限的概念
##### **定义**： #多元函数的极限
> <font color="#ccc1d9">描述：</font> $$\lim_{(x,y)\to(x_0,y_0)}f(x,y)=A$$

**解释**
+ 1. 多元函数极限的趋向性：
	+ 一元里面，自变量只有一个，因此趋向于目标点、趋向的方式比较简单，只能沿着 X 轴；
	+ 但在二元里面，自变量有两个，但 $(x,y)$ `->` $(x_0,y_0)$ 是以**任意方式**
	+ 必须保证在任何方向下，函数值都等于极限值（类似于一元极限中左右极限相等），此时才可以认为此重极限存在；
+ 2. 五大性质
	+ （1）局部有界性；
	+ （2）保号性；
	+ （3）有理运算法则；
	+ （4）极限与无穷小的关系；
	+ （5）夹逼性；
	+ 注意：没有洛必达；

### 41.1.2 基本方法
**例题**：求极限的值
+ 题目：求 $$\lim_{x\to0，y\to0}\frac{xy^{2}}{x^{2}+y^{2}}$$
+ 分析
	+ 此极限是 0 比 0 型，但是不能使用洛必达；
	+ 分母是二次，分子是三次
	+ 对 `A/B` 类型：
		+ 如果 A 的方次 > B 的方次，一般是 0；
		+ 如果 A 的方次 < B 的方次，一般是无穷；
		+ 如果 A 的方次 = B 的方次，一般是不存在；
	+ 对此，初步判断次函数极限为 0；
		+ 一元时：对 x 取绝对值，然后放缩 `->` 夹逼定理；
+ 解析
	+ 方法一：
		+ $0\leq|\frac{xy^{2}}{x^{2}+y^{2}}|\leq|x|\rightarrow0$
		+ 所以 $\lim_{x\to0，y\to0}\frac{xy^{2}}{x^{2}+y^{2}}=0$
	+ 方法二：
		+ 可以将分子的 x 提出来，x `->` 0；
		+ 并且分子提出来后、剩下的其他部分根据有界性可知不大于 1，因此整个函数的极限值为 0；

**例题**：证极限不存在
+ 题目：求 $$\lim_{x\to0，y\to0}\frac{xy^{}}{x^{2}+y^{2}}$$ 证明其极限不存在
+ 分析
	+ 分子是 2 次，分母是 2 次；
	+ 如果有两个不同的路径点、求出来的极限不同，则此极限不存在；
	+ 方法：将 `y` 限制在一条直线上；
+ 解析
	+ $$\lim_{x\to0，y=kx}\frac{xy^{}}{x^{2}+y^{2}} = \lim_{x\to0，y\to0}\frac{kx^{2}}{x^{2}+k^{2}x^{2}}=\frac{k}{1+k^2}$$
	+ 因为 k 是直线的斜率，k 不是一个定值。当 k 取不同的斜率时，极限的函数值不一样；
	+ 因此此极限不存在；

## 41.2 多元函数的连续性
**两个概念**
+ 1. 概念；
+ 2. 间断点；
+ 3. 性质；

##### **定义**： #多元函数连续的概念
> <font color="#ccc1d9">描述：</font> $$\lim_{(x,y)\to(x_0,y_0)}f(x,y)=f(x_0,y_0)$$

##### **定理**： #多元连续函数的性质
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 性质 1：多元连续函数的和、差、积、商 (分母不为零)仍为连续函数； 
> 性质 2：多元连续函数的复合函数也是连续函数；
> 性质 3：多元初等函数在其**定义区域**内连续；
> 性质 4：最大值定理 `->` 有界闭区域 D 上的连续函数在区域 D 上必能取得最大值与最小值；
> 性质 5：有界闭区域 D 上的连续函数在区域 D 上必能取得**介于最大值与最小值之间的任何值**；

## 41.3 偏导数
### 41.3.1 偏导数基础概念
##### **定义**： #偏导数
> <font color="#ccc1d9">描述：</font>如果是对 $z=f(x,y)$ 函数，会有两个偏导数的定义：
> 1. 对 X 的偏导数：对 X 偏导时，Y 固定在 $y_0$ 处（对 x 没有任何影响），$x在x。处有\Delta x$ 的增量，此时只有 x 一个变量，此时称： 
>     $$\lim_{\Delta x\to0}\frac{f\left(x_{0}+\Delta x,y_{0}\right)-f\left(x_{0},y_{0}\right)}{\Delta x}$$ 为对 X 的偏导数；
>     记作：
> 	    $\left.\frac{\partial z}{\partial x}\right|_{(x_{0},y_{0})},\left.\frac{\partial f}{\partial x}\right|_{(x_{0},y_{0})},z_{_z}(x_{0},y_{0})或$ $f_{x}(x_{0},y_{0})$
> 2. 对 Y 的偏导数：和 X 同理，
>     $$lim_{\Delta y\to0}\frac{f(x_{0},y_{0}+\Delta y)-f(x_{0},y_{0})}{\Delta y}$$
>     记为：
> 	    $\left.\text{}\frac{\partial z}{\partial y}\right|_{(x_{0},y_{0})},\left.\frac{\partial f}{\partial y}\right|_{(x_{0},y_{0})},z_{y}(x_{0},y_{0})\text{或}f_{y}(x_{0},y_{0}).$

**解释**
+ X 的偏导数：
	+ 解释：
		+ 本质上就是对 x 的一元函数导数，表示沿着 X 轴方向上、函数的变化率；
	+ 其他形式：$$\frac{\partial f(x,y)}{\partial x}$$
+ Y 的偏导数：
	+ 解释：
		+ 本质上就是对 y 的一元函数导数，表示沿着 Y 轴方向上、函数的变化率；
	+ 其他形式： 
		+ $$\frac{\partial f(x,y)}{\partial y}$$
+ 总结：本质上就是一元函数的导数；

**方法**：如何求对 x 或者 y 的偏导
+ 当 $z=f(x,y)$ 时，把 y 或者 x 视为常数，直接对 x 或者 y 求导；
+ 例：$z=x^{2}+3xy+y^{2}在(1.2)处$ 的偏导数；
	+ 第一步：求出偏导后的函数
		+ 对 x 求偏导：$\frac{\partial z}{\partial x}=2x+3y$
		+ 对 y 求偏导：$$\frac{\partial z}{\partial y}=3x+2y$$
	+ 第二步：将 $(1.2)$ 点带入对 x 求偏导或者对 y 求偏导后的函数： 2 x+3 y 或者 3 x+2 y，即可得到结果

### 41.3.2 判断偏导数是否存在
**题型**：判断偏导数是否存在
+ 方法一：定义法
	+ 利用偏导数的定义，将函数值分别带入 Y 的偏导和 X 的偏导，求代入后的函数的极限值，计算其极限是否存在；
+ 方法二：本质法
	+ 因为偏导数本质上是一元函数的导数；
	+ 所以可以直接将偏导数的 X 或 Y 当中一个数值带进去（值确定的那一个）
	+ 比如求对 X 的偏导数，此时可以直接把 Y 的值带进去，求对 X 的一元函数导数极限；

### 41.3.3 偏导数的几何意义
##### **定义**： #二元函数偏导数的几何意义
> <font color="#ccc1d9">描述：</font> 曲面 $Z=f(x,y)$
> 1.  $f_x(x_0,y_0)$ 代表的是在 $y=f(x)$ 这一直线上，$x_0$ 点对 $y=f(x)$ 的切线；
> 2.  $f_y(x_0,y_0)$ 代表的是在 $x=f(y)$ 这一直线上，$x_0$ 点对 $x=f(y)$ 的切线； 

### 41.3.4 高阶偏导数 
##### **定义**： #高阶偏导数
> <font color="#ccc1d9">描述：</font> 
> $$\frac{\partial}{\partial x}\biggl(\frac{\partial z}{\partial x}\biggr)=\frac{\partial^{2}z}{\partial x^{2}}=f_{xx}^{\prime\prime}\quad\frac{\partial}{\partial y}\biggl(\frac{\partial z}{\partial x}\biggr)=\frac{\partial^{2}z}{\partial x\partial y}=f_{xy}^{\prime\prime}$$
> $$\frac{\partial}{\partial x}\Bigg(\frac{\partial z}{\partial y}\Bigg)=\frac{\partial^{2}z}{\partial y\partial x}=f_{yx}^{\prime\prime}\quad\frac{\partial}{\partial y}\Bigg(\frac{\partial z}{\partial y}\Bigg)=\frac{\partial^{2}z}{\partial y^{2}}=f_{yy}^{\prime\prime}$$ 

**解释**
+ 混合偏导数：
	+ $f_{xy}^{\prime\prime}$
	+ $f_{yx}^{\prime\prime}$

##### **定理**： #高阶偏导数定理
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果函数 $z=f(x,y)$ 的两个二阶混合偏导数 $\frac{\partial^2z}{\partial x\partial y}$ 及 $\frac{\partial^2z}{\partial y\partial x}$ 在区域 $D$ 内连续，则在该区域内：
> $$\frac{\partial^2z}{\partial x\partial y}=\frac{\partial^2z}{\partial y\partial x}$$

**解释**
+ 先对 x 或者先对 y 时，极限值一样；

## 41.4 多元函数的全微分 
##### **定义**： #多元函数的全微分 
> <font color="#ccc1d9">描述：</font> 若 $\Delta z=f(x_0+\Delta x,y_0+\Delta y)-f(x_0,y_0)=A\Delta x+B\Delta y+o(\rho)$，则称函数 $z=f(x,y)$ 在点 $(x_0,y_0)$ 处可微分；
> 多元的微分：$$dz=A\Delta x+B\Delta y$$

##### **定理**： #可微的必要条件 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\begin{aligned}&\text{如果}z=f(x,y)\text{ 在点}\left(x_0,y_0\right)\text{处可微},\text{则在点}\left(x_0,y_0\right)\text{处}\frac{\partial z}{\partial x},\frac{\partial z}{\partial y}\text{ 必定存在,即以下式子存在}\end{aligned}$：$$\mathbf{d}z=\frac{\partial z}{\partial x}\mathbf{d}x+\frac{\partial z}{\partial y}\mathbf{d}y$$

**解释**
+ 可微分 `->` 可导；
+ 可导 `-x>` 可微分；
+ 一阶偏导数连续 `->` 可微分；
+ 可微分 `-x>` 一阶偏导数连续；

**方法**：用定义判断可微分性（充要条件）
+ （1）$$f_{x}(x_{0},y_{0})与 f_{y}(x_{0},y_{0})\text{ 是否都存在}$$
	+ 如果有一个不存在，则肯定不可微分；
	+ 如果两个都 存在，则进入到（2）进行判断；
+ （2）$$\lim_{(\Delta x,\Delta y)\to(0,0)}\frac{\Delta z-[f_{x}(x_{0},y_{0})\Delta x+f_{y}(x_{0,}y_{0})\Delta y]}{\sqrt{\left(\Delta x\right)^{2}+\left(\Delta y\right)^{2}}}是否为零$$
	+ 解释：
		+ 根据 $\Delta z=f(x_0+\Delta x,y_0+\Delta y)-f(x_0,y_0)=A\Delta x+B\Delta y+o(\rho)$ 将 $f(x_0+\Delta x,y_0+\Delta y)-f(x_0,y_0)$ 放到左边去；
		+ 看 $\Delta z-(f(x_0+\Delta x,y_0+\Delta y)-f(x_0,y_0))$ 是否和 $o(\rho)$ 相除为 `0`；
	+ 结论：
		+ 以上极限存在、并且为 0  `->` 可微；
		+ 如果不存在或不为 0 `->` 不可微；
	+ 含义：
		+ 以上公式的含义 `->` 因为一点的微分 $dz$ 其等于 $A\Delta x+B\Delta y+o(\rho)$，因此当这一点微分存在时，${dz-A\Delta x+B\Delta y}除以{o(\rho)}$ 是否为零，可以直到其微分是否存在；

##### **定理**： #可微的充分条件 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $z=f(x,y)$ 的偏导数 $\frac{\partial z}{\partial x},\frac{\partial z}{\partial y}$ 在点 $(x_0,y_0)$ 处连续，则函数 $z=f(x,y)$ 在点 $(x_0,y_0)$ 处可微；

**解释**
+ 概念：
	+ 两个偏导数在一点连续 `->` 作为二元函数在 x、y 分别趋向 $x_0、y_0$ 时偏导数存在；
+ 结论：
	+ 两个偏导数连续 `->` 可微分；

## 41.5 连续、可偏导、可微之间关系
**一元函数**
+ 图示：
	+ ![[Pasted image 20240504025921.png]]

**多元函数**
+ 1. 和一元相同点：
	+ （1）连续 `-x>` 可导；
	+ （2）可微 `->` 可偏导；
	+ （3）可微 `->` 连续；
	+ （4）连续 `-x>` 可导；
+ 2. 和一元不同点：
	+ 原因：
		+ 不一样的地方，都是**可偏导导致出来的**，为什么多元不行？
		+ 可偏导实际上是 $f_x(x_0,y_0)$ 和 $f_y(x_0,y_0)$ 的偏导数； 
		+ $f_x(x_0,y_0)$ `->` $f(x,y_0)$ 在 $y=y_0$ 这一条线上，函数发生变化，只和这一条线上的函数值有关； 
		+ $f_y(x_0,y_0)$ `->` $f(x_0,y)$ 在 $x=x_0$ 这一条线上，函数发生变化，只和这一条线上的函数值有关；
		+ 而连续 `->` 其是一个重极限，因为它要求、函数在任意方向的变化都是连续的，而偏导数只能决定在某一条线上、当前的导数是否存在，因此不能说明任意方向上是否连续；
		+ 一元的可导为什么可以：因为一元当中，可导表示了这个区域内都是可导的，因此可导 `->` 可微且连续；
	+ 概念：
		+ （1）可偏导 `-x>` 连续；
		+ （2）可偏导 `-x>` 可微；
+ 3. 和一元相比新的点：
	+ （1）偏导数连续 `->` 可微；
	+ （2）可微 `-x>` 偏导数连续；
+ 图示：
	+ 和

## 41.5 常考题型

---
### 题型： #连续、偏导数、全微分及其之间关系
#### PART 1：解题方法
**判断方法**
+ 判断是否可微：
	+ 1. 定义法：
		+ 第一步：判断 $f_{x}(x_{0},y_{0})与 f_{y}(x_{0},y_{0})\text{ 是否都存在}$；
		+ 第二步：使用以下定义，判断其重极限是否存在；
			+ 公式： $$\lim_{(\Delta x,\Delta y)\to(0,0)}\frac{\Delta z-[f_{x}(x_{0},y_{0})\Delta x+f_{y}(x_{0,}y_{0})\Delta y]}{\sqrt{\left(\Delta x\right)^{2}+\left(\Delta y\right)^{2}}}是否为零$$
+ 判断是否可导：
	+ 1. 定义法：分别求对 x 的偏导、y 的偏导，使用偏导数定义、分析偏导数对应的一元函数导数是否存在；
		+ 公式（X 偏导）：$$\lim_{\Delta x\to0}\frac{f\left(x_{0}+\Delta x,y_{0}\right)-f\left(x_{0},y_{0}\right)}{\Delta x}$$
	+ 2. 先带后求：
+ 判断是否连续：
	+ 1. 定义法：
		+ （1）证明连续：在某点的函数值是否等于其函数的极限值，如果等于、则连续；
		+ （2）证明不连续：同；
	+ 2. 特殊 `y` 值法：
		+ 用某一固定的 y 的函数带入函数当中，经常用于证明不连续；
		+ 常用形式：
			+ $y=kx$ 
			+ $y=0$
+ 判断偏导数是否连续：
	+ 注意：
		+ 多元函数连续 `≠` 多元函数偏导数连续；
		+ 偏导数是否连续，是指的 **对 X 或对 Y 的偏导数** 这个导函数是否连续；
	+ 1. 定义法：利用对 X 或对 Y 的偏导数函数定义求解：
		+ 如果以下公式不成立，则偏导数不连续；
		+ 公式（对 X 的偏导数函数）：$$\lim_{x\to0,y\to0}f_{x}(x,y)=f_{x}(0,0)$$


#### PART 2：典型例题
**例题**：二元函数 $$f(x,y)=\begin{cases}\frac{xy}{x^{2}+y^{2}},&(x,y)\neq(0,0),\\0,&(x,y)=(0,0)\end{cases}$$ 在点 $(0,0)$ 处连续、偏导数是否存在？
+ 分析
	+ 判断是否连续 `->` 这一点的函数值是否等于函数的极限值；
+ 解析
	+ 判断连续：
		+ 对 $\lim_{x\to0,y\to0}\frac{xy}{x^{2}+y^{2}}$ 用 $y=kx$ 带进去，得到证明其极限不存在 `->` 不连续；
	+ 判断偏导数：
		+ 求 x 的偏导：$f_{x}^{\prime}(0,0)=\lim_{x\to0}\frac{f(x,0)-f(0,0)}{x}=\lim_{x\to0}\frac{0-0}{x}$ `->` 偏导数为 0；
		+ 求 y 的偏导：方法和对 x 求类似，得到的结果也是偏导数为 0；
		+ 所以偏导数存在；
#### PART 3：知识点复盘